package com.bxm.adx.common.aspect.log;

import com.bxm.adx.common.adapter.AdxContext;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.log.datalog.DataLogDao;
import com.bxm.adx.common.sell.BidRequest;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author zhangdong
 * @date 2022/9/8
 */
@Component
@Aspect
@Slf4j
public class SspLogAspect {

    @Autowired
    private DataLogDao dataLogDao;

    @After(value = "@annotation(com.bxm.adx.common.aspect.log.SspLog)")
    public void after() {
        AdxContext adxContext = AdxContextFactory.get();
        if (adxContext == null) {
            return;
        }
        BidRequest bidRequest = adxContext.getBidRequest();
        if (bidRequest == null || CollectionUtils.isEmpty(bidRequest.getImps())) {
            return;
        }
        if (!dataLogDao.existDataLog(bidRequest.getImps().get(0).getTag_id(), null)) {
            return;
        }
        adxContext.setSspLog(true);
        log.debug("name:{},sspRequest:{},sspResponse:{}"
                , adxContext.getName(), adxContext.getOriginRequest(), adxContext.getReturnResponse());
    }

}
