package com.bxm.adx.common.buy.dispatcher.abtest.cached;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherConfig;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfig;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfigChangeHandler;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

/**
 * @author fgf
 * @date 2022/12/7
 **/
@Configuration
public class DispatcherCached implements DispatcherABConfigChangeHandler {
    /**
     * 流量分配配置-流量分配详情集合
     * <pre>
     * |-----------------------|-------------------------------|
     * |    Key                | Value                         |
     * |-----------------------|-------------------------------|
     * | {positionId-configId} | [dispatcher1, dispatcher2,...]|
     * |-----------------------|-------------------------------|
     * </pre>
     */
    private final ConcurrentHashMap<String, Set<Dispatcher>> configDispatcherMap = new ConcurrentHashMap<>();

    @Override
    public void doUpdate(DispatcherABConfig old, DispatcherABConfig latest) {
        if (isExecuteUpdateAndDoDelete(old, latest)) {
            List<DispatcherConfig> dispatcherConfigs = latest.getDispatcherConfigCaches();
            if (CollectionUtils.isEmpty(dispatcherConfigs)) {
                return;
            }

            String positionId = latest.getPositionId();

            for (DispatcherConfig dispatcherConfig : dispatcherConfigs) {
                List<Dispatcher> dispatchers = dispatcherConfig.getDispatcherDspCaches();
                if (CollectionUtils.isEmpty(dispatchers)) {
                    continue;
                }

                configDispatcherMap.put(buildKey(positionId, dispatcherConfig.getId()), dispatchers.stream().collect(Collectors.toSet()));
            }
        }
    }

    @Override
    public void doDelete(DispatcherABConfig old) {
        List<DispatcherConfig> dispatcherConfigs = old.getDispatcherConfigCaches();
        if (CollectionUtils.isEmpty(dispatcherConfigs)) {
            return;
        }

        String positionId = old.getPositionId();

        for (DispatcherConfig dispatcherConfig : dispatcherConfigs) {
            configDispatcherMap.remove(buildKey(positionId, dispatcherConfig.getId()));
        }
    }

    public Set<Dispatcher> getDispatchers(String positionId, String configId) {
        return configDispatcherMap.get(buildKey(positionId, configId));
    }

    private static String buildKey(String positionId, String configId) {
        return positionId + "-" + configId;
    }
}
