package com.bxm.adx.common.buy.position;

import lombok.Data;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 广告位端点数据
 * see com.bxm.mccms.facade.model.pushable.AdvertPointCacheVo
 * @author fgf
 * @date 2022/7/15
 **/
@Data
public class AdvertPoint implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 应用id
     */
    private String appId;

    /**
     * 广告平台ID
     */
    private Long dspId;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 应用包名
     */
    private String appPackage;

    /**
     * 广告位id
     */
    private String positionId;

    /**
     * 广告位名称
     */
    private String positionName;

    /**
     * 广告位类型 0：其他   1：开屏 2：信息流 3：插屏 4：banner 5:激励视频  6：全屏视频
     */
    private Integer positionType;

    /**
     * 结算方式：1分成，2固价，3实时竞价
     */
    private Integer settleType;

    /**
     * 结算配置
     */
    private BigDecimal settleConfig;

    private Integer respondTime;

    /**
     * 版本好
     */
    private String version;

    /**
     * 模板id
     */
    private String templateId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 控制开关是否关闭    0：否  1：是
     */
    private Integer deleted;
    /**
     * 广告位宽高 w*h
     */
    private String positionSize;

    public String getUniqueKey() {
        return dspId + "-" + appId + "-" + positionId;
    }

    public Size getImpressionSize() {
        String regex = "\\*";
        if (StringUtils.isEmpty(positionSize)) {
            return null;
        }
        String[] wh = positionSize.split(regex);
        if (wh.length != 2) {
            return null;
        }
        String w = wh[0];
        String h = wh[1];
        if (NumberUtils.isNumber(w) && NumberUtils.isNumber(h)) {
            Size size = new Size();
            size.setH(Integer.valueOf(h));
            size.setW(Integer.valueOf(w));
            return size;
        }
        return null;
    }

    @Data
    public static class Size {
        private Integer w;
        private Integer h;
    }
}
