package com.bxm.adx.common.caching;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;

/**
 * @author fgf
 * @date 2022/12/7
 */
public class Rule implements Serializable {
    private static final long serialVersionUID = -7946033867005866194L;

    protected BigInteger id;
    protected Integer target;
    protected BigInteger targetId;
    protected Integer ruleType;
    protected String ruleValue;

    public Rule() {
    }

    public Rule(BigInteger id, Integer target, BigInteger targetId, Integer ruleType, String ruleValue) {
        this.id = id;
        this.target = target;
        this.targetId = targetId;
        this.ruleType = ruleType;
        this.ruleValue = ruleValue;
    }

    public BigInteger getId() {
        return this.id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public Integer getTarget() {
        return this.target;
    }

    public void setTarget(Integer target) {
        this.target = target;
    }

    public BigInteger getTargetId() {
        return this.targetId;
    }

    public void setTargetId(BigInteger targetId) {
        this.targetId = targetId;
    }

    public Integer getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(Integer ruleType) {
        this.ruleType = ruleType;
    }

    public String getRuleValue() {
        return this.ruleValue;
    }

    public void setRuleValue(String ruleValue) {
        this.ruleValue = ruleValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Rule)) return false;
        Rule rule = (Rule) o;
        return Objects.equals(getTarget(), rule.getTarget()) &&
                Objects.equals(getTargetId(), rule.getTargetId()) &&
                Objects.equals(getRuleType(), rule.getRuleType()) &&
                Objects.equals(getRuleValue(), rule.getRuleValue());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getTarget(), getTargetId(), getRuleType(), getRuleValue());
    }
}
