package com.bxm.adx.common.market.exchange;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import org.springframework.stereotype.Component;

import java.util.concurrent.ThreadPoolExecutor;

/**
 * @author zhangdong
 * @date 2022/11/9
 */
@Component
public class CustomRejected extends ThreadPoolExecutor.AbortPolicy implements MeterBinder {

    private Counter rejectedCounter;

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        rejectedCounter.increment();
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        rejectedCounter = Counter.builder("adx.dsp.request.rejected").register(registry);
    }
}
