package com.bxm.adx.common.market.exchange;

import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.buy.cache.BuyerResponseCache;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;

import java.util.Objects;
import java.util.concurrent.Callable;

/**
 * @author zhangdong
 * @date 2022/12/7
 */
public class ExchangeCacheCallable implements Callable<Deal> {

    private final BidRequest bidRequest;
    private final BuyerWrapper buyerWrapper;
    private final BuyerResponseCache buyerResponseCache;

    public ExchangeCacheCallable(BidRequest bidRequest, BuyerWrapper buyerWrapper, BuyerResponseCache buyerResponseCache) {
        this.bidRequest = bidRequest;
        this.buyerWrapper = buyerWrapper;
        this.buyerResponseCache = buyerResponseCache;
    }


    @Override
    public Deal call() {
        BidResponse response = buyerResponseCache.getResponse(bidRequest, buyerWrapper);
        if (Objects.nonNull(response)) {
            return new Deal(buyerWrapper.getBuyer(), bidRequest, response);
        }
        return null;
    }
}
