package com.bxm.adx.common.sell.request;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class Device implements Serializable {
    private String ua;
    @Deprecated
    private Geo geo;
    private String ip;
    private Integer device_type;
    private Integer connection_type;
    private String make;
    private String model;
    private String brand;
    private String os;
    private String osv;
    /**
     * 安卓系统版本号，安卓API等级。示例：23。av>= 29时，视为安卓系统为AndroidQ及以上
     * （VIVO预算必传）
     */
    private Integer android_version;
    @Deprecated
    private String hwv;
    private Integer h;
    private Integer w;
    private Integer dpi;
    private Integer orientation;
    private String imei;
    private String imei_md5;
    private String idfa;
    private String idfa_md5;
    private String mac;
    private String mac_md5;
    /**
     * Android ID
     */
    private String dpid;
    /**
     * Android ID md5
     */
    private String dpid_md5;
    private String oaid;
    private String oaid_md5;
    private String gaid;
    private String gaid_md5;
    private String caid;
    private String caid_version;
    /**
     * 开发者匿名设备标识符
     */
    private String vaid;
    @Deprecated
    private String cookie;
    private String imsi;
    private String ext;
    private Integer carrier;
    /**
     * 系统启动标识
     */
    private String boot_mark;
    /**
     * 系统启动更新标识
     */
    private String update_mark;

    /**
     * vivo系统ROM版本号，无法获取可填写unknow
     * （VIVO预算必传）
     */
    private String sys_version;
    /**
     * 开机时长
     */
    private Long elapse_time;
    /**
     * 设备启动时间，单位：秒
     * 示例："1600607106"
     * （广点通/穿山甲预算必传）
     */
    private String device_start_sec;
    /**
     * 设备名称的MD5值，取小写16进制的结果，长度为32个字节
     * 示例："e910dddb2748c36b47fcde5dd720eec1"
     * （广点通预算必传）
     */
    private String device_name_md5;
    /**
     * 设备machine值，取值对齐device对象的model字段
     * 示例："iPhone10,3"
     * （广点通预算必传）
     */
    private String hardware_machine;
    /**
     * 物理内存，单位：字节
     * 示例："4047224832"
     * （广点通/穿山甲预算必传）
     */
    private String physical_memory_byte;
    /**
     * 硬盘大小，单位：字节
     * 示例："127938088960"
     * （广点通/穿山甲预算必传
     */
    private String harddisk_size_byte;
    /**
     * 系统更新时间，单位：秒（保留6位小数）
     * 示例："1595214620.383940"
     * （广点通/穿山甲预算必传）
     */
    private String system_update_sec;
    /**
     * 设备model值
     * 示例："D22AP"
     * （广点通预算必传）
     */
    private String hardware_model;
    /**
     * 国家
     * 示例："CN"
     * （广点通预算必传）
     */
    private String country;
    /**
     * 语言
     * 示例："zh-Hans-CN"
     * （广点通预算必传）
     */
    private String language;
    /**
     * 时区
     * 示例："28800"
     * （广点通预算必传）
     */
    private String time_zone;
    /**
     * 微信内部SDK版本。
     */
    private Long wx_api_ver;
    /**
     * 是否已安装微信。
     */
    private Integer wx_installed;
    /**
     * 微信open SDK版本。
     */
    private String opensdk_ver;
    /**
     * wifi名称
     */
    private String wifi_name;
    /**
     * 磁盘剩余空间，单位：字节
     */
    private String sd_free_space;
    /**
     * ⼿机ROM的版本，如获取不到可传空
     * （穿山甲预算必传）
     */
    private String rom_version;
    /**
     * 系统编译时间，⼿机ROM的编译时间，如获取不到可传空
     * （穿山甲预算必传）
     */
    private String sys_compiling_time;
    /**
     * IDFV，如"336F2BC0-245B-4242-8029- 83762AB47B15"，仅ios需要回传，安卓可不填写该字段
     * （穿山甲预算必传）
     */
    private String idfv;
    /**
     * CPU数⽬，如“4”
     * （穿山甲预算必传）
     */
    private Integer cpu_num;
    /**
     * ipv6
     */
    private String ip_v6;

    public boolean isAndroid() {
        return StringUtils.equalsIgnoreCase("android", os);
    }

    public boolean isIos() {
        return StringUtils.equalsIgnoreCase("ios", os);
    }
}
