package com.bxm.adx.common.adapter;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;

import javax.servlet.http.HttpServletResponse;

/**
 * 销售方模型适配器
 *
 * @author allen
 * @since 2019-12-12
 */
public interface BidModelAdapter extends ModelAdapter {
    default AdxConstants.Media media() {
        return AdxConstants.Media.Unknown;
    }

    BidRequest convert(byte[] bytes);

    byte[] convert(BidResponse e, BidRequest bidRequest);

    default void customHttpResponse(byte[] data, HttpServletResponse response) { }

    /**
     * 拒绝返回广告时客制化响应
     * @param request
     * @param err
     * @return
     */
    default byte[] reject(BidRequest request, AdxErrEnum err) {
        return new byte[]{};
    }
}
