package com.bxm.adx.common.buy.dispatcher;

import com.bxm.adx.common.CacheKeys;
import com.bxm.adx.common.buy.dispatcher.abtest.cached.DispatcherConfigCached;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.buy.dsp.DspService;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionService;
import com.bxm.adx.facade.constant.pushable.CachePushableFields;
import com.bxm.mccms.facade.model.pushable.DispatcherAbCacheVO;
import com.bxm.mccms.facade.model.pushable.DispatcherConfigCacheVO;
import com.bxm.mccms.facade.model.pushable.DispatcherDspCacheVO;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.datasync.server.DataSyncProducer;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.xcache.Target;
import com.bxm.warcar.xcache.TargetFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@CachePush("DISPATCHERAB")
@Component
@Slf4j
public class DispatcherAB implements Pushable {
    private final Fetcher fetcher;
    private final Updater updater;
    private final com.bxm.warcar.xcache.Fetcher fetcher2;
    private final PositionService positionService;
    private final DspService dspService;
    private final DataSyncProducer dataSyncProducer;
    private final DispatcherConfigCached dispatcherConfigCached;

    public DispatcherAB(Fetcher fetcher, Updater updater, com.bxm.warcar.xcache.Fetcher fetcher2,
                        PositionService positionService, DspService dspService, DataSyncProducer dataSyncProducer, DispatcherConfigCached dispatcherConfigCached) {
        this.fetcher = fetcher;
        this.updater = updater;
        this.fetcher2 = fetcher2;
        this.positionService = positionService;
        this.dspService = dspService;
        this.dataSyncProducer = dataSyncProducer;
        this.dispatcherConfigCached = dispatcherConfigCached;
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        Object o = parameters.get(CachePushableFields.POSITION_ID);
        //参数验证
        if (Objects.isNull(o)) {
            if (log.isInfoEnabled()) {
                log.info("DISPATCHERAB push err: POSITION_ID is null");
            }
            return;
        }
        String positionId = Objects.toString(o);

        if (log.isInfoEnabled()) {
            log.info("DISPATCHERAB push {} : {}", positionId, new String(data));
        }
        DispatcherAbCacheVO dispatcherAbCacheVO = JsonHelper.convert(data, DispatcherAbCacheVO.class);
        if (dispatcherAbCacheVO == null) {
            return;
        }

        String key = dispatcherAbCacheVO.getClass().getName() + "$" + dispatcherAbCacheVO.getPositionId();
        dataSyncProducer.post(key, dispatcherAbCacheVO);
        //移除广告位下所有流量分配数据
        updater.remove(CacheKeys.Dispather.getKeyGenerator(positionId));//旧结构（新旧结构是指流量分配是否支持多配置，旧版只有单配置）
        updater.remove(CacheKeys.Dispather.getKeyGeneratorByConfig(positionId));//新结构
        Position position = positionService.getByPositionId(positionId);
        if (position != null && !StringUtils.isEmpty(position.getAppPositionId())) {
            updater.remove(CacheKeys.Dispather.getKeyGeneratorByAppPosId(position.getAppPositionId()));
            updater.remove(CacheKeys.Dispather.getKeyGeneratorByConfigAndAppPosId(position.getAppPositionId()));
        }
        updater.remove(CacheKeys.Dispather.getKeyGeneratorByAll(positionId));
        updater.remove(CacheKeys.Dispather.getDispatcherKeyGeneratorByUid(positionId));

        List<DispatcherConfigCacheVO> configs = dispatcherAbCacheVO.getDispatcherConfigCaches();
        if (CollectionUtils.isEmpty(configs)) {
            return;
        }

        for (DispatcherConfigCacheVO c : configs) {
            Integer start = c.getStart();
            Integer end = c.getEnd();
            Long configId = c.getId();
            userBucketing(positionId, configId, start, end);

            List<DispatcherDspCacheVO> dspCacheVOS = c.getDispatcherDspCaches();
            if (CollectionUtils.isEmpty(dspCacheVOS)) {
                continue;
            }
            //根据流量分配配置id存
            updater.hupdate(CacheKeys.Dispather.getKeyGeneratorByAll(positionId), configId.toString(), dspCacheVOS);

            for (DispatcherDspCacheVO dispatcher : dspCacheVOS) {
                String dspId = Objects.toString(dispatcher.getDspId());
                //适配旧数据结构
                updater.hupdate(CacheKeys.Dispather.getKeyGenerator(positionId), dspId, dispatcher);
                //新数据结构
                updater.hupdate(CacheKeys.Dispather.getKeyGeneratorByConfig(positionId), configId + "-" + dspId, dispatcher);
                if (position != null && !StringUtils.isEmpty(position.getAppPositionId())) {
                    Dsp dsp =  dspService.get(Long.valueOf(dspId));
                    if (Objects.isNull(dsp)) {
                        continue;
                    }
                    String dspCode = dsp.getDspCode();
                    //适配旧数据结构
                    updater.hupdate(CacheKeys.Dispather.getKeyGeneratorByAppPosId(position.getAppPositionId()), dspCode, dispatcher);
                    //新数据结构
                    updater.hupdate(CacheKeys.Dispather.getKeyGeneratorByConfigAndAppPosId(position.getAppPositionId()),
                            configId + "-" + dspCode, dispatcher);
                }
            }
        }
    }

    /**
     * 对应分桶和配置关系
     *
     * @param positionId
     * @param configId
     * @param start
     * @param end
     */
    private void userBucketing(String positionId, Long configId, Integer start, Integer end) {
        if (start == null || end == null) {
            start = 0;
            end = 99;
        }
        KeyGenerator keyGenerator = CacheKeys.Dispather.getKeyGeneratorByBucketing(positionId);
        for (int i = start; i <= end; i++) {
            updater.hupdate(keyGenerator, i + "", configId);
        }
    }

    /**
     * 根据分桶获取具体流量分配配置id
     *
     * @param positionId
     * @param bucket
     * @return
     */
    public Long getConfigId(String positionId, int bucket) {
        String configId = dispatcherConfigCached.getConfigId(positionId, bucket);
        if (StringUtils.isEmpty(configId)) {
            KeyGenerator keyGenerator = CacheKeys.Dispather.getKeyGeneratorByBucketing(positionId);
            return fetcher.hfetch(keyGenerator, bucket + "", Long.class);
        }
        return Long.valueOf(configId);
    }

    /**
     * 根据流量分配配置id获取分配信息
     *
     * @param positionId
     * @param configId
     * @return
     */
    public Collection<DispatcherDspCacheVO> getDispatchersByConfigId(String positionId, Long configId) {
        KeyGenerator keyGenerator = CacheKeys.Dispather.getKeyGeneratorByAll(positionId);
//        return fetcher.hfetchList(keyGenerator, configId.toString(), DispatcherDspCacheVO.class);
        Target<DispatcherDspCacheVO> target = new TargetFactory<DispatcherDspCacheVO>()
                .keyGenerator(keyGenerator)
                .cls(DispatcherDspCacheVO.class)
                .field(configId.toString())
                .skipNativeCache(false)
                .expireTimeInSecond(300)
                .build();
        return fetcher2.hfetchToList(target);
    }
}
