package com.bxm.adx.common.buy.dispatcher;

import com.bxm.adx.common.adapter.AdxContextFactory;
import lombok.Builder;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

/**
 * Dispatcher查询过滤条件参数对象
 *
 * @author fgf
 * @date 2022/9/20
 **/
@Data
@Builder
public class DispatcherParam {
    /**
     * 并发模式下
     * 平均cpm最小值
     */
    private BigDecimal minPrice;
    /**
     * 并发模式下
     * 平均cpm最大值
     */
    private BigDecimal maxPrice;
    /**
     * 已安装app定向
     */
    private List<String> installAppList;
    /**
     * 媒体包名定向
     */
    private String mediaAppPackageName;

    public boolean isSDKConcurrentModel() {
        return Objects.nonNull(minPrice) && Objects.nonNull(maxPrice) && (maxPrice.compareTo(BigDecimal.ZERO) > 0);
    }
}
