package com.bxm.adx.common.buy.dsp;

import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.datasync.server.DataSyncProducer;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.xcache.TargetFactory;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;

/**
 * For cache pushable
 *
 * <pre>
 *     name = "DSP"
 *     parameters = {}
 *     byte[] = Dsp object to json bytes
 * </pre>
 *
 * @author allen
 * @since 2019-12-18
 */
@CachePush("DSP")
@Component
@Slf4j
public class DspDaoImpl implements DspDao, Pushable, ApplicationContextAware {

    private final DataSyncProducer dataSyncProducer;
    private final DspCached dspCached;
    private ApplicationContext applicationContext;

    public DspDaoImpl(DataSyncProducer dataSyncProducer, DspCached dspCached) {
        this.dataSyncProducer = dataSyncProducer;
        this.dspCached = dspCached;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public Collection<Dsp> getAll() {
        Collection<Dsp> dsps = dspCached.getAll();
        return dsps;
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        if (log.isDebugEnabled()) {
            log.debug("dsp = {}", new String(data));
        }
        Dsp dsp = JsonHelper.convert(data, Dsp.class);
        Long id = dsp.getId();
        String key = dsp.getClass().getName() + "$" + id;
        dataSyncProducer.post(key, dsp);
        // FIXME: 2023/1/4 这里会rebuild dsp httpclient, 但是CachePush只会由一台实例处理，所以只有这台实例会rebuild？建议修改到DspDataSyncHandler?
        applicationContext.publishEvent(new DspChangedEvent(this, dsp));
    }

    private KeyGenerator getKeyGenerator() {
        return () -> KeyBuilder.build("ADX", "DSPS");
    }
}
