package com.bxm.adx.common.domain;

import com.bxm.adx.common.sell.BidRequest;
import com.bxm.warcar.integration.pair.Pair;
import lombok.Data;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.Objects;
import java.util.function.Function;

/**
 * @author allen
 * @date 2021-03-24
 * @since 1.0
 */
@Configuration
public class DefaultDomainServiceImpl implements DomainService {

    private final Pair pair;

    public DefaultDomainServiceImpl(Pair pair) {
        this.pair = pair;
    }

    @Override
    public String replaceCountDomain(BidRequest bidRequest, String baseUrl) {
        return getUrl(bidRequest, baseUrl, DomainMapping::getCount);
    }

    @Override
    public String replaceMediaDomain(BidRequest bidRequest, String baseUrl) {
        return getUrl(bidRequest, baseUrl, DomainMapping::getMedia);
    }

    @Override
    public String replaceActivityDomain(BidRequest bidRequest, String baseUrl) {
        return getUrl(bidRequest, baseUrl, DomainMapping::getActivity);
    }

    private String getUrl(BidRequest bidRequest, String url, Function<DomainMapping, String> function) {
        String serverName = bidRequest.getServerName();
        DomainMapping mapping = pair.get(serverName).toObject(DomainMapping.class);
        if (Objects.isNull(mapping)) {
            return url;
        }
        String host = function.apply(mapping);
        if (StringUtils.isBlank(host)) {
            return url;
        }
        return UriComponentsBuilder.fromUriString(url).scheme(mapping.getProtocol()).host(host).build().toUriString();
    }

    @Data
    private static class DomainMapping {
        /**
         * 协议
         */
        private String protocol;
        /**
         * 统计接口域名
         */
        private String count;
        /**
         * 多媒体资源域名
         */
        private String media;
        /**
         * 活动域名
         */
        private String activity;
    }
}
