package com.bxm.adx.common.market.exchange.rebuild.request;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.position.AdvertPoint;
import com.bxm.adx.common.buy.position.AdvertPointService;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.App;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Configuration;

import java.util.Objects;

/**
 * 重构BidRequest中的App
 * @author fgf
 * @date 2023/1/6
 **/
@Configuration
public class AppBuilder implements AdxBidRequestBuilder {
    private final AdvertPointService advertPointService;

    public AppBuilder(AdvertPointService advertPointService) {
        this.advertPointService = advertPointService;
    }

    @Override
    public void rebuildAdxBidRequest(BidRequest adxBidRequest, RequestBuildAttribute attribute) {
        Dispatcher dispatcher = attribute.getBuyerWrapper().getDispatcher();
        AdvertPoint advertPoint = advertPointService.getAdvertPointByDspId(dispatcher.getDspId().toString(), dispatcher.getDspAppid(), dispatcher.getDspPosid());
        App app = new App();
        if (Objects.nonNull(adxBidRequest.getApp())) {
            BeanUtils.copyProperties(adxBidRequest.getApp(), app);
        }
        app.setId(dispatcher.getDspAppid());
        if (StringUtils.isNotEmpty(dispatcher.getAppPackageName())) {
            app.setBundle(dispatcher.getAppPackageName());
        }
        if (Objects.nonNull(advertPoint)) {
            app.setVer(advertPoint.getVersion());
            app.setName(advertPoint.getAppName());
        }

        adxBidRequest.setApp(app);
    }
}
