package com.bxm.adx.common.market.exchange.rebuild.response;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.mccms.facade.enums.OfferSettle;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Configuration;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.Optional;

/**
 * @author fgf
 * @date 2023/1/9
 **/
@Configuration
public class BidBuilder implements AdxBidResponseBuilder {

    @Override
    public int getOrder() {
        return 2;
    }

    @Override
    public void rebuildAdxBidResponse(BidResponse bidResponse, ResponseBuildAttribute attribute) {
        Dispatcher dispatcher = attribute.getDispatcher();
        BidRequest bidRequest = attribute.getBidRequest();

        for (SeatBid seatBid : bidResponse.getSeat_bid()) {
            for (Bid bid : seatBid.getBid()) {
                if (StringUtils.isEmpty(bid.getId())) {
                    bid.setId(RandomStringUtils.randomAlphabetic(8));
                }
                if (StringUtils.isEmpty(bid.getAdid())) {
                    bid.setAdid(RandomStringUtils.randomAlphanumeric(5));
                }
                bid.setCharge_type(AdxConstants.ChargeType.CPM);
                //记录dsp出价
                bid.setDsp_price(new BigDecimal(bid.getPrice().toString()));

                bid.setDsp_appid(dispatcher.getDspAppid());
                bid.setImp_id(bidRequest.getImps().iterator().next().getId());
            }
        }
    }
}
