package com.bxm.adx.common.openlog.listener.internal;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.OpenlogConstants;
import com.bxm.adx.common.openlog.event.internal.AdxRequestEvent;
import com.bxm.adx.common.sell.builder.BuildAttribute;
import com.bxm.adx.common.sell.builder.BuildAttributeStringMacrosHandler;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

/**
 * @author fgf
 * @date 2022/6/1
 **/
@Configuration
public class DotAdxRequestEventListener implements EventListener<AdxRequestEvent> {
    private OpenLogClient openLogClient;
    private final AdxProperties properties;
    private final BuildAttributeStringMacrosHandler macrosHandler;

    public DotAdxRequestEventListener(AdxProperties properties, BuildAttributeStringMacrosHandler macrosHandler) {
        this.properties = properties;
        this.macrosHandler = macrosHandler;
    }

    @Autowired
    public void setOpenLogClient(OpenLogClient openLogClient) {
        this.openLogClient = openLogClient;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdxRequestEvent event) {
        if (event.getBidConfig().getDisDot()) {
            return;
        }
        String url = properties.getOpenLog().create(true, OpenlogConstants.Mt.ADX_REQUEST_MT, OpenlogConstants.WITHOUT_MACROS_INNER);
        BuildAttribute attribute = new BuildAttribute(OpenlogConstants.Mt.ADX_REQUEST_MT)
                .setSspRequest(event.getSspRequest())
                .setAdxRequest(event.getAdxRequest())
                .setDspId(event.getDspId())
                .setConfigId(event.getConfigId());

        url = macrosHandler.replaceAll(url, attribute);
        openLogClient.asyncRequest(url);
    }
}
