package com.bxm.adx.common.sell.position;

import com.bxm.adx.common.sell.position.cached.PositionCached;
import com.bxm.adx.common.sell.position.verify.AppVerify;
import com.bxm.adx.common.sell.position.verify.Context;
import com.bxm.adx.common.sell.position.verify.InnerPackageNameVerify;
import com.bxm.adx.common.sell.position.verify.SpecialAppIdVerify;
import com.bxm.adx.common.sell.ssp.SspRequest;
import com.bxm.adx.common.sell.ssp.req.App;
import com.bxm.mccms.facade.model.pushable.PositionInteractAppentranceRefCacheVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @since 2019-12-18
 */
@Configuration
@Slf4j
public class PositionServiceImpl implements PositionService, CommandLineRunner {
    private final SpecialAppIdVerify specialAppIdVerify;
    private final InnerPackageNameVerify innerPackageNameVerify;
    private final AppVerify appVerify;
    private final PositionCached positionCached;
    private final PositionDao positionDao;
    public PositionServiceImpl(SpecialAppIdVerify specialAppIdVerify,
                               InnerPackageNameVerify innerPackageNameVerify, AppVerify appVerify,
                               PositionCached positionCached, PositionDao positionDao) {
        this.specialAppIdVerify = specialAppIdVerify;
        this.innerPackageNameVerify = innerPackageNameVerify;
        this.appVerify = appVerify;
        this.positionCached = positionCached;
        this.positionDao = positionDao;
    }

    @Override
    public Position getByPositionId(String positionId) {
        Position position = positionCached.getPositionByTagId(positionId);
        return position;
    }

    @Override
    public PositionInteractAppentranceRefCacheVO getInteractByPositionId(String positionId) {
        return positionDao.getInteractByPositionId(positionId);
    }

    @Override
    public boolean verifyPosition(Position position, SspRequest sspRequest) {
        App app = sspRequest.getApp();
        if (app == null) {
            if (log.isWarnEnabled()) {
                log.warn("app is null");
            }
            return false;
        }
        Context context = new Context();
        context.setResult(false);
        context.setPosition(position);
        context.setAppId(app.getId());
        context.setPackageName(app.getBundle());
        context.setSdkVer(sspRequest.getVer());
        specialAppIdVerify.doVerify(context);
        return context.isResult();
    }

    @Override
    public boolean verifyPosition(Position position, String appId, String packageName, String sdkVer) {
        Context context = new Context();
        context.setResult(false);
        context.setPosition(position);
        context.setAppId(appId);
        context.setPackageName(packageName);
        context.setSdkVer(sdkVer);
        specialAppIdVerify.doVerify(context);
        return context.isResult();
    }

    @Override
    public Position getByPositionId(String appId, Integer w, Integer h, Integer positionType) {
        Position position = positionCached.getPositionByInfo(appId, w, h, positionType);
        return position;
    }

    @Override
    public void run(String... args) throws Exception {
        specialAppIdVerify.setNextVerify(innerPackageNameVerify);
        innerPackageNameVerify.setNextVerify(appVerify);
    }
}
