package com.bxm.adx.common.sell.request;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class App implements Serializable {
    private String id;
    /**
     * 应用名
     */
    private String name;
    /**-
     * 应用唯一标识，安卓为包名，IOS为number ID
     */
    private String bundle;
    private String cat;
    private String domain;
    /**
     * App在应用商店的下载链接
     */
    private String store_url;
    /**
     * 厂商应用商店版本号(vivo，小米，华为，oppo等厂商应用商店)
     */
    private String store_ver;
    private String ext;
    /**
     * app版本号
     */
    private String ver;
    /**
     * app版本号（例：20）
     * （VIVO预算必传）
     */
    private Integer ver_code;
    /**
     * 是否支持唤起微信小程序；0表示不支持，1表示支持，默认不支持
     */
    private Integer support_wx_mnp;
}
