package com.bxm.adx.common.sell.request;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Set;

/**
 * @Author: Areit
 * @Date: 2019-07-17 10:22
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class VideoAsset implements Serializable {
//    private Integer url;
    private Integer w;
    private Integer h;
    /**
     * 视频类型，1、原生视频 2、激励视频
     */
    private Integer video_type;
    /**
     * 最⼩视频长度，闭区间。以毫秒为单位
     */
    private Integer min_duration;
    /**
     * 最⼤视频长度，闭区间。以毫秒为单位
     */
    private Integer max_duration;
//    /**
//     *     支持多个,逗号分割
//     */
//    private String mime_types;
    /**
     * ⽀持的视频格式。
     * 0:没有限制
     * 1: mp4格式
     * 2: 3gpp,3gp格式
     * 3:x-msvideo, avi格式
     * 4:x-ﬂv, ﬂv格式;
     * 5:x-ms-wmv, wmv格式
     * 6:quicktime, mov格式
     * 支持多个
     */
    private Set<Integer> mime_types;
    /**
     * 视频播放形式。1：横屏 2：竖屏 3：不限
     */
    private Integer orientation;
    /**
     * 视频传递形式，0：不限 1：实时 2：预加载
     */
    private String delivery;
    /**
     * 视频的最大大小，以KB为单位
     */
    private Integer max_length;
}
