/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.adapter;

import com.bxm.adx.common.adapter.BuyModelAdapter;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.warcar.dpl2.plugin.PluginConfig;
import com.bxm.warcar.dpl2.plugin.PluginConfigAware;
import com.bxm.warcar.utils.JsonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDealExceptionBuyModelAdapter
implements BuyModelAdapter,
PluginConfigAware {
    private static final Logger log = LoggerFactory.getLogger(AbstractDealExceptionBuyModelAdapter.class);
    private PluginConfig pluginConfig;

    public void setPluginConfig(PluginConfig pluginConfig) {
        this.pluginConfig = pluginConfig;
    }

    public PluginConfig getPluginConfig() {
        return this.pluginConfig;
    }

    @Override
    public byte[] buildRequest(BidRequest request) {
        try {
            log.debug(this.pluginConfig.getKey() + " bxmRequest:{}", (Object)JsonHelper.convert((Object)request));
            byte[] bytes = this.dealRequest(request);
            log.debug(this.pluginConfig.getKey() + " request:{}", (Object)new String(bytes));
            return bytes;
        }
        catch (Exception e) {
            log.debug(this.getPluginConfig().getKey() + " buildRequest error - bxmRequest:{},ex:", (Object)JsonHelper.convert((Object)request), (Object)e);
            return this.dealRequestException(request, e);
        }
    }

    @Override
    public BidResponse buildResponse(byte[] response) {
        try {
            log.debug(this.pluginConfig.getKey() + " response:{}", (Object)new String(response));
            BidResponse bidResponse = this.dealResponse(response);
            log.debug(this.pluginConfig.getKey() + " bxmResponse:{}", (Object)JsonHelper.convert((Object)bidResponse));
            return bidResponse;
        }
        catch (Exception e) {
            log.debug(this.getPluginConfig().getKey() + " buildResponse error - response:{},ex:", (Object)new String(response), (Object)e);
            return this.dealResponseException(response, e);
        }
    }

    public abstract byte[] dealRequest(BidRequest var1);

    public byte[] dealRequestException(BidRequest bidRequest, Exception e) {
        return null;
    }

    public abstract BidResponse dealResponse(byte[] var1);

    public BidResponse dealResponseException(byte[] response, Exception e) {
        return null;
    }
}

