/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.buyer;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.buy.buyer.HttpClientBuilder;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.buy.dsp.DspChangedEvent;
import com.bxm.adx.common.utils.MapHelper;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DefaultHttpClientBuilder
implements HttpClientBuilder,
ApplicationListener<DspChangedEvent>,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpClientBuilder.class);
    private final AdxProperties properties;
    private final ConcurrentHashMap<String, CloseableHttpClient> httpClients = new ConcurrentHashMap();

    public DefaultHttpClientBuilder(AdxProperties properties) {
        this.properties = properties;
    }

    public void onApplicationEvent(DspChangedEvent event) {
        Dsp dsp = event.getDsp();
        if (Objects.isNull(dsp)) {
            return;
        }
        String dspCode = dsp.getDspCode();
        this.httpClients.put(dspCode, this.build0(dsp));
    }

    public void destroy() throws Exception {
    }

    @Override
    public HttpClient build(final Dsp dsp) {
        if (Objects.isNull(dsp)) {
            return null;
        }
        String dspCode = dsp.getDspCode();
        return (HttpClient)MapHelper.get(this.httpClients, dspCode, new MapHelper.InitializingValue<CloseableHttpClient>(){

            @Override
            public CloseableHttpClient initializing() {
                return DefaultHttpClientBuilder.this.build0(dsp);
            }
        });
    }

    private CloseableHttpClient build0(Dsp dsp) {
        int connectTimeOutInMillis = this.properties.getBuyerBiddingConnectTimeOutInMillis();
        int socketTimeOutInMillis = this.properties.getBuyerBiddingSocketTimeOutInMillis();
        if (Objects.nonNull(dsp)) {
            connectTimeOutInMillis = Objects.nonNull(dsp.getConnectTimeOut()) ? dsp.getConnectTimeOut() : connectTimeOutInMillis;
            socketTimeOutInMillis = Objects.nonNull(dsp.getSocketTimeOut()) ? dsp.getSocketTimeOut() : socketTimeOutInMillis;
        }
        SocketConfig socketConfig = SocketConfig.custom().build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultSocketConfig(socketConfig);
        connectionManager.setDefaultMaxPerRoute(this.properties.getBuyerDefaultMaxPerRoute());
        connectionManager.setMaxTotal(this.properties.getBuyerMaxTotal());
        RequestConfig config = RequestConfig.custom().setConnectTimeout(connectTimeOutInMillis).setCookieSpec(this.properties.getBuyerCookieSpec()).setSocketTimeout(socketTimeOutInMillis).build();
        if (log.isInfoEnabled()) {
            log.info("[{}] Rebuild HttpClient instance. connectTimeOut={}, socketTimeOut={}", new Object[]{dsp.getDspCode(), connectTimeOutInMillis, socketTimeOutInMillis});
        }
        return org.apache.http.impl.client.HttpClientBuilder.create().evictExpiredConnections().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
    }
}

