/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher.abtest.cached;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfig;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherABConfigChangeHandler;
import com.bxm.adx.common.buy.dispatcher.abtest.DispatcherConfig;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DispatcherConfigCached
implements DispatcherABConfigChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(DispatcherConfigCached.class);
    private final ConcurrentHashMap<String, String> userBucketMap = new ConcurrentHashMap();

    @Override
    public void doUpdate(DispatcherABConfig old, DispatcherABConfig latest) {
        if (this.isExecuteUpdateAndDoDelete(old, latest)) {
            List<DispatcherConfig> dispatcherConfigs = latest.getDispatcherConfigCaches();
            if (CollectionUtils.isEmpty(dispatcherConfigs)) {
                return;
            }
            String positionId = latest.getPositionId();
            for (DispatcherConfig dispatcherConfig : dispatcherConfigs) {
                List<Dispatcher> dispatchers;
                String configId = dispatcherConfig.getId();
                if (Objects.isNull(configId) || CollectionUtils.isEmpty(dispatchers = dispatcherConfig.getDispatcherDspCaches())) continue;
                Integer start = dispatcherConfig.getStart();
                Integer end = dispatcherConfig.getEnd();
                if (Objects.isNull(start) || Objects.isNull(end)) continue;
                for (int i = start.intValue(); i <= end; ++i) {
                    this.userBucketMap.put(DispatcherConfigCached.buildKey(positionId, i), configId);
                }
            }
        }
    }

    @Override
    public void doDelete(DispatcherABConfig old) {
        String positionId = old.getPositionId();
        for (int i = 0; i < 100; ++i) {
            this.userBucketMap.remove(DispatcherConfigCached.buildKey(positionId, i));
        }
    }

    public String getConfigId(String positionId, int bucket) {
        return this.userBucketMap.get(DispatcherConfigCached.buildKey(positionId, bucket));
    }

    private static String buildKey(String positionId, int bucket) {
        return positionId + "-" + bucket;
    }
}

