/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.creative.replace;

import com.bxm.adx.common.creative.replace.ReplaceCreative;
import com.bxm.adx.common.creative.replace.ReplaceCreativeCaching;
import com.bxm.adx.common.creative.replace.ReplaceCreativeDao;
import com.bxm.mccms.facade.model.adx.AdxReplaceCreativeFacadeDTO;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.datasync.server.DataSyncProducer;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CachePush(value="ADX_REPLACE_CREATIVE")
public class ReplaceCreativeDaoImpl
implements ReplaceCreativeDao,
Pushable {
    private static final Logger log = LoggerFactory.getLogger(ReplaceCreativeDaoImpl.class);
    private final DataSyncProducer dataSyncProducer;
    private final ReplaceCreativeCaching replaceCreativeCaching;

    public ReplaceCreativeDaoImpl(DataSyncProducer dataSyncProducer, ReplaceCreativeCaching replaceCreativeCaching) {
        this.dataSyncProducer = dataSyncProducer;
        this.replaceCreativeCaching = replaceCreativeCaching;
    }

    public void push(Map<String, Object> parameters, byte[] data) {
        AdxReplaceCreativeFacadeDTO creativeFacadeDTO;
        if (log.isInfoEnabled()) {
            log.info("replace creative data = {}", JsonHelper.convert((byte[])data, String.class));
        }
        if (Objects.isNull(creativeFacadeDTO = (AdxReplaceCreativeFacadeDTO)JsonHelper.convert((byte[])data, AdxReplaceCreativeFacadeDTO.class)) || Objects.isNull(creativeFacadeDTO.getId())) {
            return;
        }
        String key = creativeFacadeDTO.getClass().getName() + "$" + creativeFacadeDTO.getId();
        this.dataSyncProducer.post(key, (Object)creativeFacadeDTO);
    }

    private KeyGenerator getKeyGenerator(String id) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "REPLACE_CREATIVE", id});
    }

    @Override
    public List<ReplaceCreative> queryCreativeListByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        ArrayList creatives = Lists.newArrayListWithCapacity((int)ids.size());
        for (Long id : ids) {
            if (Objects.isNull(id)) continue;
            ReplaceCreative replaceCreative = null;
            replaceCreative = (ReplaceCreative)this.replaceCreativeCaching.get(String.valueOf(id));
            if (Objects.isNull(replaceCreative)) {
                if (!log.isWarnEnabled()) continue;
                log.warn("replace-creative id = {}, not exist", (Object)id);
                continue;
            }
            creatives.add(replaceCreative);
        }
        return creatives;
    }
}

