/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.log.ssplog;

import com.bxm.adx.common.adapter.AdxContext;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.log.LogRecord;
import com.bxm.adx.common.log.datalog.DataLogDao;
import com.bxm.adx.common.sell.BidRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SspLogRecord {
    private static final Logger log = LoggerFactory.getLogger(SspLogRecord.class);
    private final DataLogDao dataLogDao;

    public SspLogRecord(DataLogDao dataLogDao) {
        this.dataLogDao = dataLogDao;
    }

    public void logRecord(String name, LogRecord logRecord) {
        AdxContext adxContext = AdxContextFactory.get();
        BidRequest bidRequest = adxContext.getBidRequest();
        if (!this.dataLogDao.existDataLog(bidRequest.getImps().get(0).getTag_id(), null)) {
            return;
        }
        if (logRecord == null) {
            logRecord = LogRecord.builder().build();
        }
        adxContext.setSspLog(true);
        log.debug("name:{},sspRequest:{},sspResponse:{}", new Object[]{name, logRecord.getSspRequest(), logRecord.getSspResponse()});
    }
}

