/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange;

import com.alibaba.fastjson.JSONException;
import com.bxm.adx.common.adapter.BuyModelAdapter;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.buyers.BuyerWrapper;
import com.bxm.adx.common.buy.cache.BuyerResponseCache;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.log.datalog.DataLogDao;
import com.bxm.adx.common.log.dsplog.DspLogRecord;
import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.exchange.ExchangeContext;
import com.bxm.adx.common.market.exchange.ExchangeParam;
import com.bxm.adx.common.market.exchange.rebuild.response.AdxBidResponseBuildFactory;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.micrometer.BuyerMeter;
import com.bxm.adx.common.openlog.event.internal.AdxRequestEvent;
import com.bxm.adx.common.openlog.event.internal.DspBidEvent;
import com.bxm.adx.common.sell.BidConfig;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.rebuild.request.RebuildRequestChain;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.JsonHelper;
import java.util.EventObject;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExchangeCallable
implements Callable<Deal> {
    private static final Logger log = LoggerFactory.getLogger(ExchangeCallable.class);
    private final Buyer buyer;
    private final Dispatcher dispatcher;
    private final BidRequest bidRequest;
    private final BidRequest adxBidRequest;
    private final BuyerMeter buyerMeter;
    private final ExchangeParam exchangeParam;
    private final EventPark eventPark;
    private final BuyerResponseCache buyerResponseCache;
    private final CountDownLatch waitCountDown;
    private final CountDownLatch overtimeCountDown;
    private final BidConfig bidConfig;
    private final DataLogDao dataLogDao;
    private final DspLogRecord dspLogRecord;
    private final RebuildRequestChain requestChain;
    private final AdxBidResponseBuildFactory responseBuildFactory;

    public ExchangeCallable(BuyerWrapper buyer, BidRequest bidRequest, BidRequest adxBidRequest, BuyerMeter buyerMeter, ExchangeParam exchangeParam, EventPark eventPark, BuyerResponseCache buyerResponseCache, CountDownLatch waitCountDown, CountDownLatch overtimeCountDown, BidConfig bidConfig, DataLogDao dataLogDao, DspLogRecord dspLogRecord, RebuildRequestChain requestChain, AdxBidResponseBuildFactory responseBuildFactory) {
        this.buyer = buyer.getBuyer();
        this.dispatcher = buyer.getDispatcher();
        this.bidRequest = bidRequest;
        this.adxBidRequest = adxBidRequest;
        this.buyerMeter = buyerMeter;
        this.exchangeParam = exchangeParam;
        this.eventPark = eventPark;
        this.buyerResponseCache = buyerResponseCache;
        this.waitCountDown = waitCountDown;
        this.overtimeCountDown = overtimeCountDown;
        this.bidConfig = bidConfig;
        this.dataLogDao = dataLogDao;
        this.dspLogRecord = dspLogRecord;
        this.requestChain = requestChain;
        this.responseBuildFactory = responseBuildFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Deal call() {
        long startTime = System.currentTimeMillis();
        String name = this.buyer.getCode();
        BuyModelAdapter modelAdapter = this.buyer.getModelAdapter();
        if (null == modelAdapter) {
            log.warn("BuyModelAdapter [{}] not found!", (Object)name);
            return null;
        }
        byte[] request = null;
        Deal deal = null;
        try {
            ExchangeContext.putBidRequest(this.bidRequest);
            ExchangeContext.putBuyer(this.buyer);
            ExchangeContext.putDispatch(this.dispatcher);
            this.rebuildAdxBidRequest();
            this.dataLog();
            ExchangeContext.putAdxRequest(this.adxBidRequest);
            request = modelAdapter.buildRequest(this.adxBidRequest);
            if (ArrayUtils.isEmpty((byte[])request)) {
                Deal deal2 = null;
                return deal2;
            }
            Dsp dsp = this.buyer.getDsp();
            String configId = "";
            if (Objects.nonNull(this.dispatcher) && Objects.nonNull(this.dispatcher.getConfigId())) {
                configId = this.dispatcher.getConfigId().toString();
            }
            this.eventPark.post((EventObject)new AdxRequestEvent(this, this.bidRequest, this.adxBidRequest, dsp.getId().toString(), configId, this.bidConfig));
            this.buyerMeter.increaseRequest(this.buyer);
            byte[] response = this.offer(request);
            if (ArrayUtils.isEmpty((byte[])response)) {
                throw new AdxException(AdxErrEnum.DSP_EMPTY_RESPONSE);
            }
            deal = new Deal(this.buyer, request, response, this.bidRequest, this.adxBidRequest);
            if (!deal.isBidSuccess()) {
                throw new AdxException(AdxErrEnum.DSP_EMPTY_RESPONSE);
            }
            this.dspLogRecord.dspLog(this.bidRequest, deal.getBidResponse(), this.dispatcher);
            this.rebuildResponse(deal);
            this.eventPark.post((EventObject)new DspBidEvent(this, this.bidRequest, this.adxBidRequest, deal.getBidResponse(), dsp.getId().toString(), this.bidConfig));
            this.buyerMeter.increasePadding(this.buyer);
            Deal interval = deal;
            return interval;
        }
        catch (Exception e) {
            AdxErrEnum errEnum = this.dealException(e);
            Deal deal3 = new Deal(this.buyer, request, this.bidRequest, this.adxBidRequest, errEnum);
            return deal3;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long interval = endTime - startTime;
            if (log.isDebugEnabled()) {
                log.debug("buy = {}, interval = {}", (Object)JsonHelper.convert((Object)this.buyer), (Object)interval);
            }
            if (interval < this.bidRequest.getWaitTime()) {
                this.waitCountDown.countDown();
            } else if (interval < this.bidRequest.getOvertime()) {
                this.overtimeCountDown.countDown();
            } else if (Objects.nonNull(deal) && deal.isBidSuccess()) {
                this.buyerResponseCache.saveResponse(deal.getAdxRequest(), deal.getBidResponse(), this.buyer);
            }
            ExchangeContext.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] offer(byte[] request) {
        byte[] response;
        long start = System.nanoTime();
        try {
            response = this.buyer.offer(request);
        }
        finally {
            this.buyerMeter.recordRequest(this.buyer, start);
        }
        return response;
    }

    private AdxErrEnum dealException(Exception e) {
        AdxErrEnum adxErrEnum = null;
        if (e instanceof AdxException) {
            AdxException adxException = (AdxException)e;
            adxErrEnum = adxException.getAdxErrEnum();
        } else if (!(e instanceof JSONException) && log.isErrorEnabled()) {
            log.error("deal call err", (Throwable)e);
        }
        adxErrEnum = Optional.ofNullable(adxErrEnum).orElse(AdxErrEnum.UNKNOWN_ERR);
        return adxErrEnum;
    }

    private void rebuildAdxBidRequest() {
        this.requestChain.handler(this.dispatcher, this.adxBidRequest);
    }

    private void dataLog() {
        for (Impression impression : this.bidRequest.getImps()) {
            ExchangeContext.putDataLog(this.dataLogDao.existDataLog(impression.getTag_id(), this.dispatcher.getDspPosid()));
        }
    }

    private void rebuildResponse(Deal deal) {
        if (deal.isOp()) {
            return;
        }
        ResponseBuildAttribute attribute = ResponseBuildAttribute.builder().bidRequest(deal.getBidRequest()).dispatcher(this.dispatcher).build();
        this.responseBuildFactory.buildAdxBidResponse(deal.getBidResponse(), attribute);
    }
}

