/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.request;

import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.position.AdvertPoint;
import com.bxm.adx.common.buy.position.AdvertPointService;
import com.bxm.adx.common.buy.position.Constants;
import com.bxm.adx.common.market.exchange.rebuild.request.AdxBidRequestBuilder;
import com.bxm.adx.common.market.exchange.rebuild.request.RequestBuildAttribute;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.common.sell.request.Native;
import com.bxm.mcssp.common.enums.app.DockingMethodTypeEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ImpressionBuilder
implements AdxBidRequestBuilder {
    private final AdvertPointService advertPointService;

    public ImpressionBuilder(AdvertPointService advertPointService) {
        this.advertPointService = advertPointService;
    }

    @Override
    public void rebuildAdxBidRequest(BidRequest adxBidRequest, RequestBuildAttribute attribute) {
        Buyer buyer = attribute.getBuyerWrapper().getBuyer();
        Dispatcher dispatcher = attribute.getBuyerWrapper().getDispatcher();
        AdvertPoint advertPoint = this.advertPointService.getAdvertPointByDspId(dispatcher.getDspId().toString(), dispatcher.getDspAppid(), dispatcher.getDspPosid());
        List<Impression> oldImpressions = adxBidRequest.getImps();
        ArrayList<Impression> newImpressions = new ArrayList<Impression>();
        Iterator<Impression> iterator = oldImpressions.iterator();
        if (iterator.hasNext()) {
            Impression impression = iterator.next();
            Impression newImpression = new Impression();
            BeanUtils.copyProperties((Object)impression, (Object)newImpression);
            if (this.needReplaceTagIdByDsp(adxBidRequest, buyer)) {
                newImpression.setTag_id(dispatcher.getDspPosid());
            }
            if (this.needReplaceByAdvertPoint(adxBidRequest)) {
                this.handleAdvertPoint(advertPoint, newImpression, buyer);
            }
            this.handleBidFloor(newImpression, dispatcher);
            newImpressions.add(newImpression);
        }
        adxBidRequest.setImps(newImpressions);
    }

    private void handleAdvertPoint(AdvertPoint advertPoint, Impression newImpression, Buyer buyer) {
        if (Objects.nonNull(advertPoint)) {
            Integer newImpType;
            Integer positionType;
            AdvertPoint.Size size = advertPoint.getImpressionSize();
            if (Objects.nonNull(size)) {
                newImpression.setH(size.getH());
                newImpression.setW(size.getW());
            }
            if (StringUtils.isNotEmpty((String)advertPoint.getTemplateId())) {
                Native an = new Native();
                if (Objects.nonNull(newImpression.getA_native())) {
                    BeanUtils.copyProperties((Object)newImpression.getA_native(), (Object)an);
                }
                an.setTemplate(advertPoint.getTemplateId());
                newImpression.setA_native(an);
            }
            if (Objects.nonNull(positionType = advertPoint.getPositionType()) && "qihang".equalsIgnoreCase(buyer.getCode()) && Objects.nonNull(newImpType = Constants.getPositionSceneTypeByPositionType(positionType))) {
                newImpression.setImp_type(newImpType);
            }
        }
    }

    private void handleBidFloor(Impression newImpression, Dispatcher dispatcher) {
        BigDecimal dspBasePrice = dispatcher.getDspBasePrice();
        if (Objects.nonNull(dspBasePrice)) {
            newImpression.setBid_floor(dspBasePrice.movePointRight(2));
        }
        newImpression.setBid_floor(newImpression.getBid_floor().setScale(0, 0));
    }

    private boolean needReplaceTagIdByDsp(BidRequest request, Buyer buyer) {
        DockingMethodTypeEnum typeEnum = this.dockingMethodTypeEnum(request);
        if (Objects.isNull(typeEnum)) {
            return true;
        }
        switch (typeEnum) {
            case SDK_OPERATION: {
                return !"scene".equalsIgnoreCase(buyer.getCode());
            }
        }
        return true;
    }

    private boolean needReplaceByAdvertPoint(BidRequest request) {
        DockingMethodTypeEnum typeEnum = this.dockingMethodTypeEnum(request);
        return !DockingMethodTypeEnum.SDK_OPERATION.equals((Object)typeEnum);
    }

    private DockingMethodTypeEnum dockingMethodTypeEnum(BidRequest request) {
        Integer dockingMethodType = request.getDockingMethodType();
        DockingMethodTypeEnum typeEnum = DockingMethodTypeEnum.get((Integer)dockingMethodType);
        return typeEnum;
    }
}

