/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.filter.Filter;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.Ordered;
import org.springframework.util.ClassUtils;

@Primary
@Configuration
public class Filters
implements Filter,
ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(Filters.class);
    private Collection<Filter> filters;

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.filters = event.getApplicationContext().getBeansOfType(Filter.class).values();
        this.filters.removeIf(filter -> Filters.class.equals((Object)ClassUtils.getUserClass((Object)filter)));
        this.filters = this.filters.stream().sorted(Comparator.comparing(Ordered::getOrder)).collect(Collectors.toList());
    }

    @Override
    public void filter(List<Deal> deals) {
        if (log.isDebugEnabled()) {
            log.debug("before filter deal list size={}", (Object)deals.size());
        }
        for (Filter filter : this.filters) {
            filter.filter(deals);
            if (!log.isDebugEnabled()) continue;
            log.debug("filter-{} deal list size={}", filter.getClass(), (Object)deals.size());
        }
        if (log.isDebugEnabled()) {
            log.debug("after filter deal list size={}", (Object)deals.size());
        }
    }

    public int getOrder() {
        return 0;
    }
}

