/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.filter;

import com.bxm.adx.common.market.Deal;
import com.bxm.adx.common.market.filter.Filter;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.common.utils.MapHelper;
import com.bxm.mcssp.common.enums.app.DockingMethodTypeEnum;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.util.CollectionUtils;

@Order(value=0x7FFFFFFF)
@Configuration
public class PriceLowerFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(PriceLowerFilter.class);

    @Override
    public void filter(List<Deal> deals) {
        Optional<Bid> topPriceBid = deals.stream().filter((? super T deal) -> Objects.nonNull(deal.getBidResponse())).map(Deal::getBidResponse).filter((? super T bidResponse) -> org.apache.commons.collections.CollectionUtils.isNotEmpty(bidResponse.getSeat_bid())).map(BidResponse::getSeat_bid).flatMap(Collection::stream).filter((? super T seatBid) -> org.apache.commons.collections.CollectionUtils.isNotEmpty(seatBid.getBid())).map(SeatBid::getBid).flatMap(Collection::stream).filter((? super T bid) -> Objects.nonNull(bid.getPrice())).sorted(Comparator.comparing(Bid::getPrice).reversed()).findFirst();
        if (!topPriceBid.isPresent()) {
            if (log.isDebugEnabled()) {
                log.debug("No valid price");
            }
            deals.removeIf(deal -> true);
            return;
        }
        BigDecimal topPrice = topPriceBid.get().getPrice();
        HashMap higher = Maps.newHashMap();
        String key = "higher";
        deals.removeIf(deal -> {
            BidRequest request = deal.getBidRequest();
            BidResponse response = deal.getBidResponse();
            if (null == response) {
                return true;
            }
            List<SeatBid> seatBids = response.getSeat_bid();
            if (org.apache.commons.collections.CollectionUtils.isEmpty(seatBids)) {
                return true;
            }
            seatBids.removeIf(seatBid -> {
                List<Bid> bidList = seatBid.getBid();
                if (org.apache.commons.collections.CollectionUtils.isEmpty(bidList)) {
                    return true;
                }
                bidList.removeIf(b -> {
                    BigDecimal price = b.getPrice();
                    if (null == price) {
                        return true;
                    }
                    if (this.isCpc(request)) {
                        return false;
                    }
                    BigDecimal bidFloor = null;
                    if (this.isApi(request)) {
                        bidFloor = request.getImps().iterator().next().getBid_floor();
                    }
                    if (Objects.nonNull(bidFloor) && price.compareTo(bidFloor) < 0) {
                        return true;
                    }
                    if (price.compareTo(topPrice) < 0) {
                        return true;
                    }
                    if (price.compareTo(topPrice) == 0) {
                        if (CollectionUtils.isEmpty((Map)higher)) {
                            MapHelper.get(higher, key, price);
                            return false;
                        }
                        return true;
                    }
                    log.warn("warning bid top price wrong, top price = {},  deal = {}", (Object)topPrice.toString(), (Object)JsonHelper.convert((Object)deal));
                    MapHelper.get(higher, key, price);
                    return false;
                });
                return org.apache.commons.collections.CollectionUtils.isEmpty(bidList);
            });
            return org.apache.commons.collections.CollectionUtils.isEmpty(seatBids);
        });
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private boolean isApi(BidRequest request) {
        return Objects.nonNull(request.getDockingMethodType()) && DockingMethodTypeEnum.API_OPERATION.getType().equals(request.getDockingMethodType());
    }

    private boolean isCpc(BidRequest request) {
        int bidModel = Optional.ofNullable(request.getBid_model()).orElse(1);
        return 2 == bidModel;
    }
}

