/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell.position.cached;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionChangeHandler;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PositionCached
implements PositionChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(PositionCached.class);
    private final AdxProperties properties;
    private final ConcurrentHashMap<String, Position> positionIdMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Position> mediaPositionIdMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Position> positionInfoMap = new ConcurrentHashMap();

    public PositionCached(AdxProperties properties) {
        this.properties = properties;
    }

    @Override
    public void doUpdate(Position old, Position latest) {
        if (this.isExecuteUpdateAndDoDelete(old, latest)) {
            String infoKey;
            this.positionIdMap.put(latest.getPositionId(), latest);
            String mediaPositionId = latest.getAppPositionId();
            if (StringUtils.isNotEmpty((String)mediaPositionId)) {
                this.mediaPositionIdMap.put(mediaPositionId, latest);
            }
            if (this.isBesPosition(latest) && StringUtils.isNotEmpty((String)(infoKey = this.buildMapKeyByPosition(latest)))) {
                this.positionInfoMap.put(infoKey, latest);
            }
        }
    }

    @Override
    public void doDelete(Position old) {
        String infoKey;
        this.positionIdMap.remove(old.getPositionId());
        String mediaPositionId = old.getAppPositionId();
        if (StringUtils.isNotEmpty((String)mediaPositionId)) {
            this.mediaPositionIdMap.remove(mediaPositionId);
        }
        if (this.isBesPosition(old) && StringUtils.isNotEmpty((String)(infoKey = this.buildMapKeyByPosition(old)))) {
            this.positionInfoMap.remove(infoKey);
        }
    }

    public Position getPositionByTagId(String tagId) {
        return Optional.ofNullable(this.positionIdMap.get(tagId)).orElse(this.mediaPositionIdMap.get(tagId));
    }

    public Position getPositionById(String positionId) {
        return this.positionIdMap.get(positionId);
    }

    public Position getPositionByAppTagId(String positionId) {
        return this.mediaPositionIdMap.get(positionId);
    }

    public Position getPositionByInfo(String appId, Integer w, Integer h, Integer positionScene) {
        if (StringUtils.isEmpty((String)appId)) {
            return null;
        }
        if (Objects.isNull(w) || Objects.isNull(h)) {
            return null;
        }
        if (Objects.isNull(positionScene)) {
            return null;
        }
        String key = this.buildMapKey(appId, w, h, positionScene);
        return this.positionInfoMap.get(key);
    }

    public String buildMapKeyByPosition(Position position) {
        String appId = position.getAppId();
        String positionSize = position.getPositionSize();
        Byte scene = position.getPositionScene();
        if (StringUtils.isEmpty((String)appId)) {
            return null;
        }
        if (StringUtils.isEmpty((String)positionSize)) {
            return null;
        }
        if (Objects.isNull(scene)) {
            return null;
        }
        String size = positionSize.split(" ")[0];
        String val = appId + "-" + position.getPositionScene() + "-" + size;
        return val;
    }

    public String buildMapKey(String appId, int w, int h, int positionScene) {
        String val = appId + "-" + positionScene + "-" + w + "*" + h;
        return val;
    }

    private boolean isBesPosition(Position position) {
        if (!org.springframework.util.StringUtils.isEmpty((Object)position.getPositionSize())) {
            if (position.getAppId().equals(this.properties.getBesAndroidAppId())) {
                return true;
            }
            if (position.getAppId().equals(this.properties.getBesIosAppId())) {
                return true;
            }
        }
        return false;
    }
}

