/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher.control;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherFlowControl;
import com.bxm.adx.common.buy.dispatcher.control.AlgoFlowControlCached;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.App;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class AlgoDispatcherFlowControl
implements DispatcherFlowControl {
    private final AlgoFlowControlCached algoFlowControlCached;

    public AlgoDispatcherFlowControl(AlgoFlowControlCached algoFlowControlCached) {
        this.algoFlowControlCached = algoFlowControlCached;
    }

    @Override
    public boolean flowControl(Dispatcher dispatcher, BidRequest request) {
        String bundle;
        Set<String> algoBundles = this.algoFlowControlCached.getAlgoControlBundles(dispatcher);
        if (CollectionUtils.isEmpty(algoBundles)) {
            return false;
        }
        App app = request.getApp();
        String string = bundle = Objects.isNull(app) ? null : app.getBundle();
        if (StringUtils.isEmpty((String)bundle)) {
            return false;
        }
        return algoBundles.contains(bundle);
    }
}

