/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher.filter;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherContext;
import com.bxm.adx.common.buy.dispatcher.filter.AbstractCrowdPackageFilter;
import com.bxm.adx.common.caching.Id;
import com.bxm.adx.common.limiter.DeleteExpiredHandler;
import com.bxm.warcar.cache.Fetcher;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlackCrowdPackageFilter
extends AbstractCrowdPackageFilter {
    private static final Logger log = LoggerFactory.getLogger(BlackCrowdPackageFilter.class);

    public BlackCrowdPackageFilter(Fetcher fetcher, DeleteExpiredHandler deleteExpiredHandler) {
        super(fetcher, deleteExpiredHandler);
    }

    @Override
    public void filter(DispatcherContext<Dispatcher> context, Set<Id> trash) {
        Collection<Dispatcher> dispatchers = context.getValues();
        HashSet remove = Sets.newHashSet();
        for (Dispatcher dispatcher : dispatchers) {
            Set black = (Set)this.dispatcherBlackCrowdIds.get(dispatcher.getId());
            if (!this.hit(context, black)) continue;
            remove.add(dispatcher);
        }
        if (CollectionUtils.isNotEmpty((Collection)remove)) {
            trash.addAll(remove);
        }
    }

    public int getOrder() {
        return 3;
    }
}

