/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.buy.dispatcher.filter;

import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherContext;
import com.bxm.adx.common.buy.dispatcher.DispatcherFlowControl;
import com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilter;
import com.bxm.adx.common.caching.Id;
import com.bxm.adx.common.sell.BidRequest;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowControlFilter
implements DispatcherFilter<Dispatcher> {
    private static final Logger log = LoggerFactory.getLogger(FlowControlFilter.class);
    private final DispatcherFlowControl dispatcherFlowControl;
    private final Config config;

    public FlowControlFilter(DispatcherFlowControl dispatcherFlowControl) {
        this.dispatcherFlowControl = dispatcherFlowControl;
        this.config = new Config();
    }

    @Override
    public void filter(DispatcherContext<Dispatcher> context, Set<Id> trash) {
        Collection<Dispatcher> dispatchers = context.getValues();
        if (CollectionUtils.isEmpty(dispatchers)) {
            return;
        }
        BidRequest request = context.getRequest();
        Set removes = dispatchers.stream().filter(dispatcher -> {
            Byte flowSwitch = dispatcher.getChopQuantitySwitch();
            if (Objects.nonNull(flowSwitch) && 1 == flowSwitch) {
                String bucket = context.getAlgoFlowControlBucket();
                if (StringUtils.isEmpty((String)bucket)) {
                    String uid = this.initUid();
                    bucket = this.config.bucketIds[this.bucket(uid)];
                    context.setAlgoFlowControlBucket(bucket);
                }
                dispatcher.setAlgoFlowControlBucket(bucket);
                if (this.config.bucketIds[0].equals(bucket)) {
                    return this.dispatcherFlowControl.flowControl((Dispatcher)dispatcher, request);
                }
            }
            return false;
        }).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(removes)) {
            trash.addAll(removes);
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private String initUid() {
        String uid = AdxContextFactory.get().getUid();
        if (StringUtils.isBlank((String)uid)) {
            uid = RandomStringUtils.randomAlphanumeric((int)8);
        }
        return uid;
    }

    private int bucket(String uid) {
        double[] bucketWeights = this.config.bucketWeights;
        int numBuckets = this.config.bucketNum;
        int hash = Hashing.murmur3_32().hashString((CharSequence)uid, StandardCharsets.UTF_8).asInt();
        hash = Math.abs(hash);
        double totalWeight = 0.0;
        for (double weight : bucketWeights) {
            totalWeight += weight;
        }
        double randomValue = (double)hash / 2.147483647E9 * totalWeight;
        double cumulativeWeight = 0.0;
        for (int i = 0; i < numBuckets; ++i) {
            if (!(randomValue < (cumulativeWeight += bucketWeights[i]))) continue;
            return i;
        }
        return numBuckets - 1;
    }

    static class Config {
        private String name = "flow-control02";
        private int bucketNum = 2;
        private double[] bucketWeights = new double[]{0.99, 0.01};
        private String[] bucketIds = new String[]{"a2", "b2"};

        public String getName() {
            return this.name;
        }

        public int getBucketNum() {
            return this.bucketNum;
        }

        public double[] getBucketWeights() {
            return this.bucketWeights;
        }

        public String[] getBucketIds() {
            return this.bucketIds;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setBucketNum(int bucketNum) {
            this.bucketNum = bucketNum;
        }

        public void setBucketWeights(double[] bucketWeights) {
            this.bucketWeights = bucketWeights;
        }

        public void setBucketIds(String[] bucketIds) {
            this.bucketIds = bucketIds;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getBucketNum() != other.getBucketNum()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            if (!Arrays.equals(this.getBucketWeights(), other.getBucketWeights())) {
                return false;
            }
            return Arrays.deepEquals(this.getBucketIds(), other.getBucketIds());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getBucketNum();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            result = result * 59 + Arrays.hashCode(this.getBucketWeights());
            result = result * 59 + Arrays.deepHashCode(this.getBucketIds());
            return result;
        }

        public String toString() {
            return "FlowControlFilter.Config(name=" + this.getName() + ", bucketNum=" + this.getBucketNum() + ", bucketWeights=" + Arrays.toString(this.getBucketWeights()) + ", bucketIds=" + Arrays.deepToString(this.getBucketIds()) + ")";
        }
    }
}

