/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.limiter;

import com.bxm.adx.common.limiter.InsertExpireHandler;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInsertExpireHandler
implements InsertExpireHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultInsertExpireHandler.class);
    private final BlockingQueue<QueueEntity> queue = new LinkedBlockingQueue<QueueEntity>(10000);
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("insert-expire"));
    private final Updater updater;
    private final Fetcher fetcher;

    public DefaultInsertExpireHandler(Updater updater, Fetcher fetcher) {
        this.updater = updater;
        this.fetcher = fetcher;
        this.startHandleQueue();
    }

    @Override
    public void insert(KeyGenerator hashKey, String field, String val, int expire) {
        if (!this.queue.offer(new QueueEntity(hashKey, field, val, expire)) && log.isDebugEnabled()) {
            log.debug("the queue was full.");
        }
    }

    private void startHandleQueue() {
        this.executor.execute(() -> {
            while (true) {
                try {
                    while (true) {
                        QueueEntity entity = this.queue.take();
                        KeyGenerator key = entity.hashKey;
                        int ttl = this.fetcher.ttl(key).intValue();
                        int expire = entity.expire;
                        if (log.isDebugEnabled()) {
                            log.debug("ttl {}, expire {}.", (Object)ttl, (Object)expire);
                        }
                        if (ttl > entity.expire) {
                            expire = ttl;
                        }
                        this.updater.hupdate(key, entity.field, (Object)entity.val, expire);
                        if (!log.isDebugEnabled()) continue;
                        log.debug("update key hash {} val {}.", (Object)key.generateKey(), (Object)entity.field);
                    }
                }
                catch (Exception e) {
                    log.info("take: {}", (Object)e.getMessage());
                    continue;
                }
                break;
            }
        });
    }

    static interface Ttl {
        public static final int KEY_NOT_EXIST = -2;
        public static final int KET_NO_TTL = -1;
    }

    private static class QueueEntity {
        KeyGenerator hashKey;
        String field;
        String val;
        int expire;

        private QueueEntity(KeyGenerator hashKey, String field, String val, int expire) {
            this.hashKey = hashKey;
            this.field = field;
            this.val = val;
            this.expire = expire;
        }
    }
}

