/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.filter;

import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.filter.DispatcherPriceConfigFilter;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.App;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AppPackageDispatcherPriceConfigFilter
implements DispatcherPriceConfigFilter {
    private static final Logger log = LoggerFactory.getLogger(AppPackageDispatcherPriceConfigFilter.class);

    public int getOrder() {
        return 20;
    }

    @Override
    public void filter(Collection<DispatcherPriceConfig> priceConfigs, Bid bid, SeatBid seatBid, ResponseBuildAttribute attribute) {
        String bundle = null;
        try {
            BidRequest bidRequest = attribute.getBidRequest();
            App app = bidRequest.getApp();
            bundle = app.getBundle();
        }
        catch (Exception e) {
            log.warn("adid:{},bidId:{} getAppPackage exception :", new Object[]{bid.getAdid(), bid.getId(), e});
        }
        if (log.isDebugEnabled()) {
            log.debug(" adid:{},bidId:{},bundle:{}", new Object[]{bid.getAdid(), bid.getId(), bundle});
        }
        String finalBundle = bundle;
        priceConfigs.removeIf(config -> this.whetherHitOrNot((DispatcherPriceConfig)config, finalBundle));
    }

    private boolean whetherHitOrNot(DispatcherPriceConfig config, String bundle) {
        if (config.getAppPkgFilterMode() == null) {
            return false;
        }
        if (1 == config.getAppPkgFilterMode()) {
            if (CollectionUtils.isEmpty(config.getAppPackageList())) {
                return true;
            }
            if (!config.getAppPackageList().contains(bundle)) {
                return true;
            }
        }
        if (2 == config.getAppPkgFilterMode()) {
            if (CollectionUtils.isEmpty(config.getAppPackageList())) {
                return false;
            }
            return config.getAppPackageList().contains(bundle);
        }
        return false;
    }
}

