/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.exchange.rebuild.response;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherPriceConfig;
import com.bxm.adx.common.market.exchange.rebuild.response.AdxBidResponseBuilder;
import com.bxm.adx.common.market.exchange.rebuild.response.ResponseBuildAttribute;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import com.bxm.adx.facade.constant.enums.AdxErrEnum;
import com.bxm.adx.facade.exception.AdxException;
import com.bxm.warcar.utils.JsonHelper;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PriceConfigResponseBuilder
implements AdxBidResponseBuilder {
    private static final Logger log = LoggerFactory.getLogger(PriceConfigResponseBuilder.class);

    public int getOrder() {
        return 3;
    }

    @Override
    public void rebuildAdxBidResponse(BidResponse bidResponse, ResponseBuildAttribute attribute) {
        if (MapUtils.isNotEmpty(attribute.getBidPriceConfigMap())) {
            return;
        }
        Dispatcher dispatcher = attribute.getDispatcher();
        List<DispatcherPriceConfig> dispatcherPriceConfigs = dispatcher.getDispatcherPriceConfigs();
        if (CollectionUtils.isEmpty(dispatcherPriceConfigs)) {
            log.warn("position {}, dispatcher {}, price config is empty", (Object)dispatcher.getPositionId(), (Object)dispatcher.getId());
            return;
        }
        try {
            for (SeatBid seatBid : bidResponse.getSeat_bid()) {
                for (Bid bid : seatBid.getBid()) {
                    String taskId = bid.getTask_id();
                    Integer userScoreLevel = bid.getUser_score_level();
                    if (log.isDebugEnabled()) {
                        log.debug(" adid:{},taskId:{},userScoreLevel:{}", new Object[]{bid.getAdid(), taskId, userScoreLevel});
                    }
                    Optional<DispatcherPriceConfig> optional = dispatcherPriceConfigs.stream().filter(config -> config.getFilterMode() != null && 1 == config.getFilterMode()).filter(config -> this.getPriceConfig((DispatcherPriceConfig)config, taskId, userScoreLevel)).findFirst();
                    DispatcherPriceConfig selectedConfig = optional.orElseGet(() -> dispatcherPriceConfigs.stream().filter(config -> config.getFilterMode() == null || 0 == config.getFilterMode()).findFirst().orElse(null));
                    attribute.putBidPriceConfig(bid, selectedConfig);
                    Long priceModeId = selectedConfig.getPriceModeId();
                    bid.setDpc_id(priceModeId == null ? null : priceModeId.toString());
                }
            }
        }
        catch (Exception e) {
            log.error("position {} dispatcher {} price config {}", new Object[]{dispatcher.getPositionId(), dispatcher.getId(), JsonHelper.convert(dispatcherPriceConfigs)});
            throw new AdxException(AdxErrEnum.DISPATCHER_ERR);
        }
    }

    private boolean getPriceConfig(DispatcherPriceConfig config, String taskId, Integer userScoreLevel) {
        List<String> taskIds = config.getTaskIds();
        if (CollectionUtils.isEmpty(taskIds)) {
            return false;
        }
        String interval = this.locateInterval(userScoreLevel);
        return taskIds.contains(taskId) || taskIds.contains(interval) || taskIds.contains(taskId + ":" + interval);
    }

    public String locateInterval(Integer number) {
        if (number == null) {
            return "";
        }
        if (number >= 81 && number <= 100) {
            return "81_100";
        }
        if (number >= 61 && number <= 80) {
            return "61_80";
        }
        if (number >= 41 && number <= 60) {
            return "41_60";
        }
        if (number >= 21 && number <= 40) {
            return "21_40";
        }
        if (number >= 1 && number <= 20) {
            return "1_20";
        }
        return String.valueOf(number);
    }
}

