/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.market.failover;

import com.bxm.adx.common.market.MarketFailover;
import com.bxm.adx.common.market.MarketOrders;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;

@Configuration
public class ClassPathFileReaderMarketFailover
implements MarketFailover {
    private static final Logger log = LoggerFactory.getLogger(ClassPathFileReaderMarketFailover.class);

    @Override
    public byte[] fetch(String appId, MarketOrders orders) {
        try {
            ClassPathResource resource = new ClassPathResource("/failover/" + appId);
            InputStream inputStream = resource.getInputStream();
            return IOUtils.readFully((InputStream)inputStream, (int)inputStream.available());
        }
        catch (IOException e) {
            return null;
        }
    }
}

