/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.micrometer.aspect;

import com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilter;
import com.google.common.collect.Maps;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class DispatcherFilterMicroMeter
implements MeterBinder {
    private static final Logger log = LoggerFactory.getLogger(DispatcherFilterMicroMeter.class);
    private final Map<Class, Timer> timers = Maps.newConcurrentMap();
    private final Iterable<DispatcherFilter> filters;

    public DispatcherFilterMicroMeter(Iterable<DispatcherFilter> filters) {
        this.filters = filters;
    }

    public void bindTo(MeterRegistry registry) {
        for (DispatcherFilter filter : this.filters) {
            Class clazz = ClassUtils.getUserClass((Object)filter);
            Timer timer = Timer.builder((String)"dispatcher.filter").tag("name", clazz.getName()).register(registry);
            this.timers.put(clazz, timer);
            log.info("Registering Dispatcher filter {} timer meter successful.", (Object)filter);
        }
    }

    Timer get(DispatcherFilter filter) {
        return this.timers.get(ClassUtils.getUserClass((Object)filter));
    }
}

