/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.openlog.listener.internal;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.cipher.PriceCipher;
import com.bxm.adx.common.openlog.event.internal.DspWinEvent;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.math.BigDecimal;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Configuration
public class DotDspWinEventListener
implements EventListener<DspWinEvent> {
    private static final Logger log = LoggerFactory.getLogger(DotDspWinEventListener.class);
    private OpenLogClient openLogClient;
    private final AdxProperties properties;

    public DotDspWinEventListener(AdxProperties properties) {
        this.properties = properties;
    }

    @Autowired
    public void setOpenLogClient(OpenLogClient openLogClient) {
        this.openLogClient = openLogClient;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(DspWinEvent event) {
        BigDecimal win = event.getWin();
        if (Objects.nonNull(win)) {
            MultiValueMap<String, String> originalParams = event.getOriginalParams();
            boolean success = event.getSuccess();
            LinkedMultiValueMap customizeParams = new LinkedMultiValueMap();
            try {
                String dspWinPrice = PriceCipher.encryptWin(win.toString(), this.properties.getCipherProperties().getDspPriceKey());
                originalParams.set((Object)"dprwin", (Object)dspWinPrice);
            }
            catch (Exception e) {
                log.error("win {} bidid {} err", new Object[]{win, originalParams.getFirst((Object)"bidid"), e});
            }
            customizeParams.add((Object)"srr", (Object)(success ? "1" : "0"));
            customizeParams.add((Object)"srtime", (Object)(System.currentTimeMillis() + ""));
            String url = this.properties.getOpenLog().create(9, originalParams, (MultiValueMap<String, String>)customizeParams);
            if (log.isDebugEnabled()) {
                log.debug("report second auction mt url {}", (Object)url);
            }
            this.openLogClient.asyncRequest(url);
        }
    }
}

