/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.rule;

import com.bxm.adx.common.filter.LimitConfig;
import com.bxm.adx.common.rule.Rule;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class LimitRule {
    private static final String SPLIT = ",";
    private static final String GROUP_SPLIT = "-";
    private final Rule rule;
    private final String separatorChars;
    private final String groupSeparatorChars;

    public LimitRule(Rule rule) {
        this(rule, SPLIT, GROUP_SPLIT);
    }

    public LimitRule(Rule rule, String separatorChars, String groupSeparatorChars) {
        this.rule = rule;
        this.separatorChars = separatorChars;
        this.groupSeparatorChars = groupSeparatorChars;
    }

    public Set<LimitConfig> getSet() {
        String val = this.rule.ruleValue;
        if (StringUtils.isBlank((String)val)) {
            return Sets.newHashSet();
        }
        String[] array = val.split(this.separatorChars);
        HashSet configs = Sets.newHashSetWithExpectedSize((int)array.length);
        for (String s : array) {
            LimitConfig config = this.convert(s);
            if (!Objects.nonNull(config)) continue;
            configs.add(config);
        }
        return configs;
    }

    private LimitConfig convert(String s) {
        String[] array = s.split(this.groupSeparatorChars);
        if (array.length < 4) {
            return null;
        }
        try {
            LimitConfig config = LimitConfig.builder().type(LimitConfig.LimitType.getLimitType(Integer.valueOf(array[0]))).timeWindow(Integer.valueOf(array[1])).timeUnit(this.getTimeUnit(Integer.valueOf(array[2]))).limit(Integer.valueOf(array[3])).build();
            return config;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private TimeUnit getTimeUnit(int timeUnit) {
        switch (timeUnit) {
            case 1: {
                return TimeUnit.HOURS;
            }
            case 2: {
                return TimeUnit.DAYS;
            }
        }
        throw new IllegalArgumentException("unsupported timeUnit");
    }
}

