/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.common.sell.rebuild.request;

import com.bxm.adx.common.AdxProperties;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.rebuild.request.RebuildRequestHandler;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Deprecated
public class RebuildRequestCustomDataHandler
implements RebuildRequestHandler {
    @Autowired
    private AdxProperties adxProperties;
    @Autowired
    private Fetcher fetcher;
    @Autowired
    private Updater updater;
    private final ConcurrentHashMap<Long, Double> map = new ConcurrentHashMap();

    @GetMapping(value={"/customPriceCoefficient"})
    public ResultModel customPriceCoefficient(@RequestParam(value="dspId") Long dspId, @RequestParam(value="coefficient") Double coefficient) {
        if (dspId < 0L || coefficient < 0.0 || coefficient > 1.0) {
            return ResultModelFactory.FAILED400((String)"\u53c2\u6570\u9519\u8bef");
        }
        this.updater.update(this.getKey(dspId), (Object)coefficient);
        return ResultModelFactory.SUCCESS();
    }

    private KeyGenerator getKey(Long dspId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "REQUEST", "CUSTOM", "COEFFICIENT", dspId});
    }

    @PostConstruct
    public void init() {
        List<Long> customPriceCoefficient = this.adxProperties.getCustomPriceCoefficient();
        if (CollectionUtils.isEmpty(customPriceCoefficient)) {
            return;
        }
        for (Long dspId : customPriceCoefficient) {
            this.map.put(dspId, -1.0);
        }
        this.schedule();
    }

    @Override
    public void handler(Dispatcher dispatcher, BidRequest request) {
        Long dspId = dispatcher.getDspId();
        Double priceCoefficient = this.map.get(dspId);
        if (priceCoefficient == null || priceCoefficient < 0.0) {
            return;
        }
        request.setDspPriceCoefficient(priceCoefficient);
    }

    @Scheduled(cron="0 */1 * * * ?")
    public void schedule() {
        for (Map.Entry<Long, Double> entry : this.map.entrySet()) {
            Double fetch = (Double)this.fetcher.fetch(this.getKey(entry.getKey()), Double.class);
            if (fetch == null) {
                fetch = -1.0;
            }
            this.map.put(entry.getKey(), fetch);
        }
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

