package com.bxm.adx.common.adapter.aspect;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.adapter.AbstractPluginBidModelAdapter;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.warcar.dpl2.plugin.PluginConfig;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.context.annotation.Configuration;

import java.util.Properties;

/**
 * 切面接管填充mediaId和encm
 *
 * @author fgf
 * @date 2023/5/11
 **/
@Aspect
@Configuration
public class BidModelPluginEnhanceAspect {
    @Pointcut("this(com.bxm.adx.common.adapter.BidModelAdapter) && execution(com.bxm.adx.common.sell.BidRequest convert(..))")
    public void pointcut() {}

    @AfterReturning(pointcut = "pointcut()" , returning = "returnVal")
    public void afterReturning(JoinPoint point, Object returnVal) throws Throwable {
        if (null == returnVal) {
            return;
        }
        BidRequest request = (BidRequest) returnVal;
        Object target = point.getTarget();
        if (target instanceof AbstractPluginBidModelAdapter) {
            Properties properties = getProperties(target);

            if (StringUtils.isBlank(request.getMediaId())) {
                request.setMediaId(getMediaId(properties));
            }

            if (null == request.getEncModel()) {
                request.setEncModel(getEncModel(properties));
            }
        }
    }

    /**
     * 获取插件配置
     * @param target
     * @return
     */
    private Properties getProperties(Object target) {
        AbstractPluginBidModelAdapter adapter = (AbstractPluginBidModelAdapter) target;
        PluginConfig pluginConfig = adapter.getPluginConfig();
        return pluginConfig.getProperties();
    }

    /**
     * 提供一种额外的获取mediaId的方式，旨在切断新媒体插件和Adx主项目的联系，media信息的维护可放在openlog相关文档里
     * @return
     */
    private String getMediaId(Properties properties) {
        String mediaId = properties.getProperty(AdxConstants.PluginParam.MEDIA_ID);
        return mediaId;
    }

    /**
     * @see com.bxm.adx.common.AdxConstants.EncryptionModel
     * 加密模式
     * @return
     */
    private Integer getEncModel(Properties properties) {
        String encm = properties.getProperty(AdxConstants.PluginParam.BXM_ENCRYPT_MODEL);
        try {
            Integer model = Integer.valueOf(encm);
            return model;
        } catch (Exception e) {
            //不设置和AdxConstants.EncryptionModel.UNENCRYPTED处理逻辑一样
            return AdxConstants.EncryptionModel.UNENCRYPTED;
        }
    }
}
