package com.bxm.adx.common.buy.dispatcher;

import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.position.Position;

import java.util.Collection;
import java.util.Map;

/**
 * 分发服务
 *
 * @author allen
 * @since 2019-12-16
 */
public interface DispatcherService {

    /**
     * 根据广告位获取有优先级的买方信息。
     * Key = 优先级
     * Value = 分配的DSP平台列表
     * @param position 广告位
     * @return 分发配置
     */
    Map<Integer, Collection<Dispatcher>> getPriority(Position position, BidRequest bidRequest);
}
