package com.bxm.adx.common.buy.dispatcher.control;

import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherFlowControl;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.request.App;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Objects;
import java.util.Set;

/**
 * @author fgf
 * @date 2023/11/10
 **/
@Component
public class AlgoDispatcherFlowControl implements DispatcherFlowControl {
    private final AlgoFlowControlCached algoFlowControlCached;

    public AlgoDispatcherFlowControl(AlgoFlowControlCached algoFlowControlCached) {
        this.algoFlowControlCached = algoFlowControlCached;
    }

    @Override
    public boolean flowControl(Dispatcher dispatcher, BidRequest request) {
        Set<String> algoBundles = algoFlowControlCached.getAlgoControlBundles(dispatcher);
        if (CollectionUtils.isEmpty(algoBundles)) {
            return false;
        }
        App app = request.getApp();
        String bundle = Objects.isNull(app) ? null : app.getBundle();
        if (StringUtils.isEmpty(bundle)) {
            return false;
        }
        return algoBundles.contains(bundle);
    }
}
