package com.bxm.adx.common.buy.dispatcher.reorder;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.buy.dispatcher.Dispatcher;
import com.bxm.adx.common.buy.dispatcher.DispatcherContext;
import com.bxm.adx.common.buy.dispatcher.filter.DispatcherFilter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author fgf
 * @date 2023/3/15
 **/
@Slf4j
@Configuration
public class DispatcherReorderFactory implements ApplicationListener<ApplicationReadyEvent> {

    private final Map<DispatcherOrderStrategy, DispatcherReorder> dispatcherReorders = Maps.newHashMap();

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext context = event.getApplicationContext();
        Map<String, DispatcherReorder> dispatcherReorderMap = context.getBeansOfType(DispatcherReorder.class);
        if (!CollectionUtils.isEmpty(dispatcherReorderMap)) {
            dispatcherReorders.putAll(
                    dispatcherReorderMap.values().stream()
                            .collect(Collectors.toMap(DispatcherReorder::orderStrategy, dispatcherReorder -> dispatcherReorder)));
        }
    }

    public Collection<Dispatcher> reorder(DispatcherContext<Dispatcher> context) {
        Integer dmType = context.getPosition().getDockingMethodType();
        if (Objects.nonNull(dmType) && AdxConstants.DockingMethodType.SDK == dmType.intValue()) {
            if (context.getSdkConcurrentModel()) {
                return dispatcherReorders.get(DispatcherOrderStrategy.sdk_concurrency).reorder(context);
            } else {
                return dispatcherReorders.get(DispatcherOrderStrategy.sdk_common).reorder(context);
            }
        } else {
            return context.getValues();
        }
    }
}
