package com.bxm.adx.common.buy.position;

import com.bxm.adx.common.PositionSceneTypeEnum;

/**
 * @author fgf
 * @date 2022/12/15
 **/
public class Constants {
    interface PositionType {
        int UNKNOWN = 0;
        int BOOT = 1;
        int INFORMATION_FLOW = 2;
        int SCREEN = 3;
        int BANNER = 4;
        int INSPIRE_VIDEO = 5;
        int VIDEO = 6;
    }

    public static Integer getPositionSceneTypeByPositionType(int positionType) {
        switch (positionType) {
            case PositionType.BOOT:
                return PositionSceneTypeEnum.BOOT.getType();
            case PositionType.INFORMATION_FLOW:
                return PositionSceneTypeEnum.INFORMATION_FLOW.getType();
            case PositionType.SCREEN:
                return PositionSceneTypeEnum.SCREEN.getType();
            case PositionType.BANNER:
                return PositionSceneTypeEnum.BANNER.getType();
            case PositionType.INSPIRE_VIDEO:
                return PositionSceneTypeEnum.INSPIRE_VIDEO.getType();
            case PositionType.VIDEO:
                return PositionSceneTypeEnum.VIDEO.getType();
            default:
                return null;
        }
    }
}
