package com.bxm.adx.common.caching.sync.handler;

import cn.hutool.core.bean.BeanUtil;
import com.bxm.adx.common.caching.sync.DataSyncHandler;
import com.bxm.adx.common.log.buriedSwitch.BuriedSwitch;
import com.bxm.adx.common.log.buriedSwitch.BuriedSwitchCaching;
import com.bxm.mccms.facade.model.pushable.BuriedSwitchCashVO;
import org.springframework.context.annotation.Configuration;

/**
 * @author jingyu.li
 * @date 2024-02-29
 */
@Configuration
public class BuriedSwitchDataSyncHandler implements DataSyncHandler {

    private final BuriedSwitchCaching buriedSwitchCaching;

    public BuriedSwitchDataSyncHandler(BuriedSwitchCaching buriedSwitchCaching) {
        this.buriedSwitchCaching = buriedSwitchCaching;
    }

    @Override
    public Class<?> getClazz() {
        return BuriedSwitchCashVO.class;
    }

    @Override
    public Object set(String key, Object object) {
        BuriedSwitchCashVO vo = (BuriedSwitchCashVO) object;
        BuriedSwitch buriedSwitch = new BuriedSwitch();
        BeanUtil.copyProperties(vo, buriedSwitch);
        buriedSwitchCaching.set(buriedSwitch.getPositionId() + "_" + buriedSwitch.getDspId() + "_" + buriedSwitch.getDspPosid(),buriedSwitch);
        return object;
    }
}
