package com.bxm.adx.common.caching.sync.handler;

import com.bxm.adx.common.buy.position.AdvertPoint;
import com.bxm.adx.common.caching.sync.DataSyncHandler;
import com.bxm.adx.common.sysdict.SysDict;
import com.bxm.adx.common.sysdict.SysDictCaching;
import com.bxm.mccms.facade.model.pushable.SysDictCacheVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Configuration;

/**
 * @author weixing
 */
@Slf4j
@Configuration
public class SysDictDataSyncHandler implements DataSyncHandler{
    private final SysDictCaching sysDictCaching;

    public SysDictDataSyncHandler(SysDictCaching sysDictCaching) {
        this.sysDictCaching = sysDictCaching;
    }

    @Override
    public Class<?> getClazz() {
        return SysDictCacheVO.class;
    }

    @Override
    public Object set(String key, Object object) {
        SysDictCacheVO sysDictCacheVO = (SysDictCacheVO) object;
        SysDict sysDict = new SysDict();
        BeanUtils.copyProperties(sysDictCacheVO, sysDict);
        sysDictCaching.set(String.valueOf(sysDict.getId()), sysDict);
        return object;
    }
}
