package com.bxm.adx.common.collection;

import com.bxm.adx.facade.constant.pushable.CachePushableFields;
import com.bxm.mccms.facade.model.pushable.PositionCollectionCacheVO;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Objects;

/**
 *
 * For cache pushable
 *
 * <pre>
 * name = "POSITION_COLLECTION"
 * parameters = {positionId=$positionId}
 * byte[] = PositionSdkConfig object to json bytes
 * </pre>
 * @author zhengwangeng
 * @since 2021-9-27
 */
@Component
@CachePush("POSITION_COLLECTION")
public class PositionCollectionDaoImpl implements PositionCollectionDao, Pushable {

    private final Fetcher fetcher;
    private final Updater updater;

    public PositionCollectionDaoImpl(Fetcher fetcher, Updater updater) {
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public PositionCollectionCacheVO getByPositionId(String positionId) {
        return fetcher.fetch(getKeyGenerator(positionId), PositionCollectionCacheVO.class);
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        Object o = parameters.get(CachePushableFields.POSITION_ID);
        if (Objects.isNull(o)) {
            return;
        }
        String positionId = Objects.toString(o);
        PositionCollectionCacheVO sdkConfigList = JsonHelper.convert(data, PositionCollectionCacheVO.class);

        updater.update(getKeyGenerator(positionId), sdkConfigList);
    }

    private KeyGenerator getKeyGenerator(String value) {
        return () -> KeyBuilder.build("ADX", "POSITION_COLLECTION", "POSITION_ID", value);
    }
}
