package com.bxm.adx.common.ding;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.CacheKeys;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * Created by Arei on 2020/9/24.
 *
 * 钉钉推送
 */
@Service("dingTalkService")
@Slf4j
public class DingTalkServiceImpl implements DingTalkService {
    private MessageSender dingDingMessageSender;
    private Fetcher fetcher;
    private Updater updater;

    public DingTalkServiceImpl(MessageSender dingDingMessageSender, Fetcher fetcher, Updater updater) {
        this.dingDingMessageSender = dingDingMessageSender;
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public void pushSDKActivityErr(String positionId, AdxConstants.ActivityErr err) {
        try {
            KeyGenerator keyGenerator = CacheKeys.getActivityErrGenerator(positionId, err.name());
            if (fetcher.exists(keyGenerator)) {
                if (log.isDebugEnabled()) {
                    log.debug("posid = {} have been reported ,err = {}", positionId, err.name());
                }
                return;
            } else {
                Message message = new Message();
//                message.setTos(Arrays.asList("13516820410"));
                message.setContent("posId = " + positionId + ", err = " + err.name());
                dingDingMessageSender.send2(message);
                updater.update(keyGenerator, "1", 24 * 3600);
                if (log.isDebugEnabled()) {
                    log.debug("report posid = {} ,err = {}", positionId, err.name());
                }
            }
        }catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("ding err", e);
            }
        }
    }
}
