package com.bxm.adx.common.log.buriedSwitch;

import com.bxm.mccms.facade.model.pushable.BuriedSwitchCashVO;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.datasync.server.DataSyncProducer;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

/**
 * @author jingyu.li
 * @date 2024-02-29
 */
@Slf4j
@CachePush("BURIED_SWITCH")
public class BuriedSwitchDaoImpl implements BuriedSwitchDao,Pushable {
    private final DataSyncProducer dataSyncProducer;
    private final BuriedSwitchCaching buriedSwitchCaching;

    public BuriedSwitchDaoImpl(DataSyncProducer dataSyncProducer, BuriedSwitchCaching buriedSwitchCaching) {
        this.dataSyncProducer = dataSyncProducer;
        this.buriedSwitchCaching = buriedSwitchCaching;
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        if (log.isInfoEnabled()) {
            log.info("buried switch data = {}", JsonHelper.convert(data, String.class));
        }

        BuriedSwitchCashVO convert = JsonHelper.convert(data, BuriedSwitchCashVO.class);
        if (convert == null || convert.getId() == null) {
            return;
        }

        String key = convert.getClass().getName() + "$" + convert.getId();
        dataSyncProducer.post(key, convert);
    }

    @Override
    public Boolean getBuriedSwitch(String positionId, Long dspId, String dspPosid) {
        BuriedSwitch buriedSwitch = buriedSwitchCaching.get(positionId + "_" + dspId + "_" + dspPosid);
        if (buriedSwitch == null || buriedSwitch.getOpened() == null || buriedSwitch.getOpened() == 0) {
            return false;
        }
        return true;
    }
}
