package com.bxm.adx.common.log.ssplog;

import com.bxm.adx.common.adapter.AdxContext;
import com.bxm.adx.common.adapter.AdxContextFactory;
import com.bxm.adx.common.log.datalog.DataLogDao;
import com.bxm.adx.common.sell.BidRequest;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

/**
 * @author zhangdong
 * @date 2023/2/9
 */
@Component
@Slf4j
public class SspLogRecord {

    private final DataLogDao dataLogDao;

    public SspLogRecord(DataLogDao dataLogDao) {
        this.dataLogDao = dataLogDao;
    }

    public void logRecord(String name, String request, String response) {
        try {
            AdxContext adxContext = AdxContextFactory.get();
            BidRequest bidRequest = adxContext.getBidRequest();
            if (bidRequest == null || CollectionUtils.isEmpty(bidRequest.getImps())) {
                return;
            }
            if (!dataLogDao.existDataLog(bidRequest.getImps().get(0).getTag_id(), null)) {
                return;
            }
            adxContext.setSspLog(true);
            log.debug("name:{},sspRequest:{},sspResponse:{}", name, request, response);
        } catch (Exception e) {
        }
    }
}
